<?php
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
?>
<?php require_once("../db.php"); ?>
<?php 
if (!isset($_GET["ag"]) or !in_array($_GET["ag"], array_keys($cf_agents))) {
	header("Location: analysis.php?ag=".array_key_first($cf_agents));
}
try {
	$core = Core::getInstance();
	$stmt = $core->dbh->prepare("SELECT messages.mess_client_id, messages.mess_whosent, myclients.client_number, myclients.status, myclients.premium, myclients.ag FROM messages LEFT JOIN myclients ON messages.mess_client_id = myclients.client_id WHERE mess_whosent = '0' and mess_date BETWEEN DATE_SUB(NOW(), INTERVAL ".$cf_analysis_long_days." DAY) AND NOW() and myclients.ag = :ag GROUP BY mess_client_id");
	$stmt -> bindParam("ag", $_GET["ag"], PDO::PARAM_INT);
	$stmt -> execute();
	$results = $stmt -> fetchAll(PDO::FETCH_ASSOC);
} catch(PDOException $pe) {
	trigger_error('Could not connect to MySQL database. ' . $pe->getMessage() , E_USER_ERROR);
}
?>
<?php require_once("header.php"); error_reporting(E_ALL); ?>
<link rel="stylesheet" href="css/theme.default.css">
<script>
	var cf_howlongstrings = <?= $cf_howlongstrings; ?>;
	var cf_agents = [<?= implode(",", array_keys($cf_agents)); ?>];
	var current_ag = <?= $_GET["ag"]; ?>;
</script>
    <div class="container-fluid">
	  <div class="row" style="max-height: 100vh; background: none;">
		<div class="col-2" style="height: 100vh;overflow: scroll;">
			<div class="row" style="height: 100%; margin-top: 20px;">
			
				<div class="col-12">
					<!-- Start forma crveni box -->
					<form style="background: white;color:black;padding: 7px;margin-top:20px" id="frm_bulk">
						<div class="form-group mt-3 mb-2">
						<select class="form-select1" name="sel_blk_option">
							<option value="1" selected="">Po broju</option>
							<option value="0">Po određenom vremenskom intervalu</option>
						  </select>
						</div>
						<div class="mt-1 mb-2" id="div_by_number">
						  <label for="blk_date_from" class="form-label">Broj:</label>
						  <input type="text" class="form-control" id="txt_bulk_send" name="txt_bulk_send" value="">
						</div>
						<div id="div_date_blk" style="display: none;">
							<div class="mt-1 mb-2">
							  <label for="blk_date_from" class="form-label">Datum od:</label>
							  <input class="datum-input" type="text" class="form-control" id="blk_date_from" name="blk_date_from">
							</div>
							<div class="mt-1 mb-2">
								<label for="blk_date_to" class="form-label">Datum do:</label>
								<input class="datum-input" type="text" class="form-control" id="blk_date_to" name="blk_date_to">
							</div>
							<div class="form-group mt-3 mb-2">
							<select class="form-select1" name="blk_sel_option">
								<option value="0">Svima koji su poslali poruku u intervalu</option>
								<option value="1">Samo registriranima u određenom intervalu</option>
								<option value="2">Svim novim korisnicima (u zadnjih 30 dana)</option>
								<option value="3">Svim neaktivnim</option>
								<option value="4">Svim blokiranim</option>
								<option value="5">Svima koji su pisali danas</option>
							  </select>
							</div>
						</div>
						  <div class="form-group mt-1 mb-2">
							<label for="comment">Poruka:</label>
							<textarea class="form-control" rows="4" id="blk_message" name="blk_message"></textarea>
						  </div>
						  <div class="form-group mt-1 mb-2" id="div_blk_premium" style="display: none;">
							<input class="form-check-input" type="checkbox" value="1" id="blk_premium" name="blk_premium">
							<label class="form-check-label" for="blk_premium">Samo pretplatnici</label>
						  </div>
						  <input name="inp_hidden_analysis" id="inp_blk_analysis" value="true" type="hidden" />
						<button type="button" class="btn btn-primary" id="btn_send_blk">Potvrdi</button>
						<span id="sp_blk_send"></span>
					</form>
					<form name="frm_rnd" id="frm_rnd">
						<select name="sel_rnd_quantity" style=" margin-left: 10px; padding: 4px 0;">
							<?php foreach ($cf_rnd_select as $val_rnd_sel) { ?>
							<option value="<?php echo $val_rnd_sel; ?>"><?php echo $val_rnd_sel; ?></option>
							<?php } ?>
						</select>
						<input name="inp_rnd_clientID" id="inp_rnd_clientID" value="" type="hidden" />
						<input name="inp_hidden_analysis" id="inp_rnd_analysis" value="true" type="hidden" />
						<button class="btn btn-primary" type="button" id="btn_rnd">RND</button>
					</form>
					<!-- end forma crveni box -->		
				</div>
			</div>
		</div>
		<div class="col-8" style="background: none;max-height: 100vh; margin-top: 10px;">
		    <!-- agenti -->
			<div class="row">
				<div class="col-md-12 ">
				<div class="d-flex justify-content-center">
				<form class="form-inline" id="frm_search">
				  <div class="row g-3 align-items-center">
					  <div class="col-auto">
						<label for="txt_search_term" class="col-form-label">Traži po broju ili imenu (min 3 znaka):</label>
					  </div>
					  <div class="col-auto">
						<input type="text" id="txt_search_term" class="form-control" value="">
					  </div>
					  <div class="col-auto">
						<select class="form-select" id="sel_filter" name="sel_filter" aria-label="Default select example">
						  <option value="0" selected>Svi (novi)</option>
						  <option value="2">Blokirani</option>
						  <option value="1">Pauzirani</option>
						  <option value="3">Neaktiv303</option>
						</select>
					  </div>
					  <div class="col-auto">
						<button type="submit" class="btn btn-primary float-right" id="btn_search">Traži</button>
					  </div>
				</div>
				</form>
				</div>
				</div>
			</div>
			<!-- end of agenti -->
			
			<!--- grupirane poruke po korisniku -->
			<div class="col-md-12" style="max-height: 37vmin; overflow-y: scroll; overflow-x: hidden; padding: 0 20px; margin-top: 20px;">
			<div class="row">
				<table class="table table-hover table-stripped" style="margin: 0 10px 0 10px;" id="tbl_grouped_mess">
				  <thead>
					<tr>
					  <th scope="col" style="width: 8%;">Broj</th>
					  <th scope="col">Pretplatnik</th>
					  <th scope="col">Ukupno poruka</th>
					  <th scope="col">Danas</th>
					  <th scope="col">Jučer</th>
					  <th scope="col">Zadnjih 7 dana</th>
					  <th scope="col">Ovaj mjesec</th>
					  <th scope="col">Prošli mjesec</th>
					  <th scope="col">Agent</th>
					  <th scope="col" style="width: 10%">Status</th>
					</tr>
				  </thead>
				  <tbody id="tbody_groupedMessages">
					<?php foreach ($results as $key => $value) { ?>
					<?php 
						$tr_id = "gc_".$value["mess_client_id"];					
						$th_id = "th_".$value["mess_client_id"];
						$td_id_mess = "td_id_mess_".$value["mess_client_id"];
						$td_id_date = "td_id_date_".$value["mess_client_id"];
						
						$mess_whosent = "0";
						// all messages counter
						try {
							$core = Core::getInstance();
							$stmt = $core->dbh->prepare("SELECT count(*) as sum FROM messages WHERE mess_client_id = :mess_client_id and mess_whosent = :mess_whosent");
							$stmt -> bindParam("mess_client_id", $value["mess_client_id"], PDO::PARAM_INT);
							$stmt -> bindParam("mess_whosent", $mess_whosent);
							$stmt -> execute();
							$results = $stmt -> fetchAll(PDO::FETCH_ASSOC);
							$all_messages = $results[0]["sum"];
							
						} catch(PDOException $pe) {
							trigger_error('Could not connect to MySQL database. ' . $pe->getMessage() , E_USER_ERROR);
						}
						
						// today
						try {
							$core = Core::getInstance();
							$stmt = $core->dbh->prepare("SELECT count(*) as sum FROM messages WHERE mess_client_id = :mess_client_id and mess_whosent = :mess_whosent AND date(mess_date) = CURDATE()");
							$stmt -> bindParam("mess_client_id", $value["mess_client_id"], PDO::PARAM_INT);
							$stmt -> bindParam("mess_whosent", $mess_whosent);
							$stmt -> execute();
							$results = $stmt -> fetchAll(PDO::FETCH_ASSOC);
							$today_messages = $results[0]["sum"];
							
						} catch(PDOException $pe) {
							trigger_error('Could not connect to MySQL database. ' . $pe->getMessage() , E_USER_ERROR);
						}
						
						// yesterday
						try {
							$core = Core::getInstance();
							$stmt = $core->dbh->prepare("SELECT count(*) as sum FROM messages WHERE mess_client_id = :mess_client_id and mess_whosent = :mess_whosent AND DATE(mess_date) = DATE(NOW() - INTERVAL 1 DAY)");
							$stmt -> bindParam("mess_client_id", $value["mess_client_id"], PDO::PARAM_INT);
							$stmt -> bindParam("mess_whosent", $mess_whosent);
							$stmt -> execute();
							$results = $stmt -> fetchAll(PDO::FETCH_ASSOC);
							$yesterday_messages = $results[0]["sum"];
							
						} catch(PDOException $pe) {
							trigger_error('Could not connect to MySQL database. ' . $pe->getMessage() , E_USER_ERROR);
						}
						
						// last 7 days
						try {
							$core = Core::getInstance();
							$stmt = $core->dbh->prepare("SELECT count(*) as sum FROM messages WHERE mess_client_id = :mess_client_id and mess_whosent = :mess_whosent AND DATE(mess_date) >= DATE(NOW() - INTERVAL 7 DAY)");
							$stmt -> bindParam("mess_client_id", $value["mess_client_id"], PDO::PARAM_INT);
							$stmt -> bindParam("mess_whosent", $mess_whosent);
							$stmt -> execute();
							$results = $stmt -> fetchAll(PDO::FETCH_ASSOC);
							$last7days_messages = $results[0]["sum"];
							
						} catch(PDOException $pe) {
							trigger_error('Could not connect to MySQL database. ' . $pe->getMessage() , E_USER_ERROR);
						}
						
						// this month
						try {
							$core = Core::getInstance();
							$stmt = $core->dbh->prepare("SELECT count(*) as sum FROM messages WHERE mess_client_id = :mess_client_id and mess_whosent = :mess_whosent AND MONTH(mess_date) = MONTH(CURRENT_DATE()) AND YEAR(mess_date) = YEAR(CURRENT_DATE())");
							$stmt -> bindParam("mess_client_id", $value["mess_client_id"], PDO::PARAM_INT);
							$stmt -> bindParam("mess_whosent", $mess_whosent);
							$stmt -> execute();
							$results = $stmt -> fetchAll(PDO::FETCH_ASSOC);
							$thismonth_messages = $results[0]["sum"];
							
						} catch(PDOException $pe) {
							trigger_error('Could not connect to MySQL database. ' . $pe->getMessage() , E_USER_ERROR);
						}
						
						// last month
						try {
							$core = Core::getInstance();
							$stmt = $core->dbh->prepare("SELECT count(*) as sum FROM messages WHERE mess_client_id = :mess_client_id and mess_whosent = :mess_whosent AND YEAR(mess_date) = YEAR(CURRENT_DATE - INTERVAL 1 MONTH) AND MONTH(mess_date) = MONTH(CURRENT_DATE - INTERVAL 1 MONTH)");
							$stmt -> bindParam("mess_client_id", $value["mess_client_id"], PDO::PARAM_INT);
							$stmt -> bindParam("mess_whosent", $mess_whosent);
							$stmt -> execute();
							$results = $stmt -> fetchAll(PDO::FETCH_ASSOC);
							$lastmonth_messages = $results[0]["sum"];
							
						} catch(PDOException $pe) {
							trigger_error('Could not connect to MySQL database. ' . $pe->getMessage() , E_USER_ERROR);
						}
					?>
					
						<tr id="<?= $tr_id; ?>" class="<?= tr_status($value["status"]); ?>" data-id="<?= $value["mess_client_id"]; ?>">
							<th id="<?= $th_id; ?>" scope="row" class="<?php echo ($value["mess_whosent"] == "0") ? "nored" : ""; ?>"><?= $value["client_number"]; ?></th>
							<td><?= $value["premium"] ?></td>
							<td><?= $all_messages ?></td>
							<td><?= $today_messages ?></td>
							<td><?= $yesterday_messages ?></td>
							<td><?= $last7days_messages ?></td>
							<td><?= $thismonth_messages ?></td>
							<td><?= $lastmonth_messages ?></td>
							<td><?= $value["ag"]; ?></td>
							<td>
								<select id="client_ST<?= $value["mess_client_id"]; ?>" class="form-select sel_status_css" name="client_ST<?= $value["mess_client_id"]; ?>" data-id="<?= $value["mess_client_id"]; ?>">
								  <?php foreach ($cf_status as $key_cfs => $value_cfs) { ?>
								  <option value="<?= $key_cfs; ?>" <?php if (!strcmp($key_cfs, $value["status"])) { echo "selected"; } ?>><?= $value_cfs; ?></option>
								  <?php } ?>
								</select>
							</td>
						</tr>
						<!--<i class="fas fa-exclamation"></i>-->
						
					<?php } ?>
				  </tbody>
				</table>
			</div>
			</div>
			<!-- end of grupirane poruke po korisniku -->
			
			<hr />
			
			<!-- glavni chat -->
			<div class="col-md-12" style="position: relative;" >
				<div class="row">
						<div class="chat d-flex flex-column justify-content-between" style="height: 58vh;">
						
							<div class="chat-history" style="max-height: 45vmin; overflow: scroll;">
							
								<div class="mt-1 mb-1 text-center" id="div_main_chat_show_more" style="display: none;">
									<button class="btn btn-secondary" style="width: 20%;margin: 0 auto;" type="button" id="btn_main_chat_showmore" data-from="" data-clientid="">Učitaj još (<span id="current_main_chat_grouped"></span>/<span id="total_main_chat_grouped"></span>)</button>
								</div>
								
								<ul class="m-b-0" id="ul-mainChat">
									
								</ul>
							</div>
							
							<div class="chat-message clearfix" style="position: absolute;bottom: 0;width: 100%; display: none;" id="div_reply">
								<form name="frm_reply" id="frm_reply">
								<div class="input-group mb-0" style="width: 83%; float: left;">
									<div class="input-group-prepend">
										
									</div>
									<textarea class="form-control" name="txta_reply" placeholder="Unesi poruku ovdje" rows="3" cols="50" id="txta_reply"></textarea>
									
									<input name="inp_reply_clientID" id="inp_reply_clientID" value="" type="hidden" />
									
								</div>
								</form>
							</div>
						</div>
					
				</div>
			</div>
			<!-- end of glavni chat -->
		</div>
		<div class="col-2" style="height: 100vh; overflow: scroll;">
			<div class="row" style="margin-top: 20px;">
				<div class="card-header">Napomene</div>
						<div class="card-body">
							<div class="col-sm-12">
								
								<form id="frm_client_details">
								  <div class="form-group">
									<label for="Broj">Broj</label>
									<input type="text" class="form-control" name="client_number" id="client_number" placeholder="Unesite broj" disabled="true" value="">
								  </div>
								  <div class="form-group">
									<label for="ime">Ime</label>
									<input type="text" class="form-control" name="client_name" id="client_name" placeholder="Unesite ime" value="">
								  </div>
								  <div class="form-group">
									<label for="date">Datum</label>
									<input type="text" class="form-control" name="client_date" id="client_date" placeholder="Unesite datum" value="">
								  </div>
								  <div class="form-group">
									<label for="exampleFormControlTextarea1">Napomena</label>
									<textarea class="form-control" name="client_description" id="client_description" rows="7"></textarea>
								  </div>
								  <div class="form-group">
									<input class="form-check-input" type="checkbox" value="1" id="premium" name="premium">
									<label class="form-check-label" for="premium">Pretplatnik</label>
								  </div>
								  <div class="form-check">
									<label class="form-check-label" for="exampleCheck1">Zadnja izmjena: <span id="client_last_edited"></span></label>
								  </div>
								  <input type="hidden" name="client_id" id="client_id" value="" />
								  <button type="submit" onclick="updateClientDetails();" class="btn btn-primary float-right">Spremi</button>
								</form>
								
							</div>
							<br />
							<hr style="margin-top: 20px;" />
							<div class="col-sm-12">
								
								<i class="fas fa-mail-bulk"></i> Bulk: <strong id="sum_blk"></strong>
								&nbsp;
								<i class="fas fa-envelope-open-text"></i> Primljeno: <strong id="sum_tot_received"></strong>
								&nbsp;
								<i class="far fa-clock"></i> 24 sata: <strong id="sum_24h"></strong>
								<br />								
							</div>
						</div>
			</div>
		</div>
	  </div>
	</div>
	<!-- end of container -->
	
	<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js" integrity="sha384-IQsoLXl5PILFhosVNubq5LC7Qb9DXgDA9i+tQ8Zj3iwWAwPtgFTxbJ8NT4GN1R8p" crossorigin="anonymous"></script>
	<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.min.js" integrity="sha384-cVKIPhGWiC2Al4u+LWgxfKTRIcfu0JTxR+EQDz/bgldoEyl4H0zUF0QKbrJ0EcQF" crossorigin="anonymous"></script>
	<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
	<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
	<script src="js/common.js"></script>
	<script src="js/analysis.js"></script>
	<script src="js/jquery.tablesorter.min.js"></script>
	<script src="js/jquery.tablesorter.widgets.min.js"></script>
	<script type="text/javascript">
		$(function() {
			$("#tbl_grouped_mess thead th:eq(10)").data("sorter", false);
			$("#tbl_grouped_mess").tablesorter();
		});
	</script>
	<!--<script src="js/index.js"></script>-->
  </body>
</html>
