<?php require_once("../db.php"); ?>
<?php 
if (!isset($_GET["ag"]) or !in_array($_GET["ag"], array_keys($cf_agents))) {
	header("Location: index.php?ag=".array_key_first($cf_agents));
	//echo "ne postoji";
}
try {
	
	$core = Core::getInstance();
	$stmt = $core->dbh->prepare("SELECT m.*, myclients.* FROM messages m INNER JOIN (SELECT mess_client_id, MAX(mess_date) as mess_date FROM messages GROUP BY mess_client_id) as mymax USING (mess_client_id, mess_date) LEFT JOIN myclients on myclients.client_id = m.mess_client_id WHERE ag = :ag GROUP BY m.mess_client_id ORDER BY m.mess_date DESC LIMIT 0, :cf_max_grouped_messages");
	$stmt -> bindParam("ag", $_GET["ag"], PDO::PARAM_INT);
	$stmt -> bindParam("cf_max_grouped_messages", $cf_max_grouped_messages, PDO::PARAM_INT);
	$stmt -> execute();
	$results = $stmt -> fetchAll(PDO::FETCH_ASSOC);
} catch(PDOException $pe) {
	trigger_error('Could not connect to MySQL database. ' . $pe->getMessage() , E_USER_ERROR);
}
?>
<?php require_once("header.php"); ?>
<script>
	var cf_howlongstrings = <?= $cf_howlongstrings; ?>;
	var cf_agents = [<?= implode(",", array_keys($cf_agents)); ?>];
	var current_ag = <?= $_GET["ag"]; ?>;
</script>
    <div class="container-fluid">
	  <div class="row" style="max-height: 100vh; background: none;">
		<div class="col-2" style="height: 100vh;overflow: scroll;">
			<div class="row" style="height: 100%; margin-top: 20px;">
				<div class="col-12">
				    <!-- start of novi brojevi -->
					<div class="card" style="height: 17vh; overflow: scroll;">
						<div class="card-header">Novi brojevi</div>
						<div class="card-body">
							<table class="table">
							  <thead>
								<tr>
								  <th scope="col">SMS</th>
								  <th scope="col">Broj</th>
								  <th scope="col">Agent</th>
								</tr>
							  </thead>
							  <tbody id="new_numbers">
								
								
							  </tbody>
							</table>
						</div>
					</div>
					<!-- end of novi brojevi -->
					
					<!-- start of neaktivni -->
					<div class="card" style="height: 25vh; overflow: scroll; margin-top: 20px;">
						<div class="card-header">Neaktivni</div>
						<div class="card-body">
							<table class="table">
							  <thead>
								<tr>
								  <th scope="col">Broj</th>
								</tr>
							  </thead>
							  <tbody id="inactive">
								
								
							  </tbody>
							</table>
						</div>
					</div>
					<!-- end of neaktivni -->

					<!-- Start forma crveni box -->
					<form style="background: white;color:black;padding: 7px;margin-top:20px" id="frm_bulk">
						<div class="mt-1 mb-2">
						  <label for="blk_date_from" class="form-label">Datum od:</label>
						  <input class="datum-input" type="text" class="form-control" id="blk_date_from" name="blk_date_from">
						</div>
						<div class="mt-1 mb-2">
							<label for="blk_date_to" class="form-label">Datum do:</label>
							<input class="datum-input" type="text" class="form-control" id="blk_date_to" name="blk_date_to">
						</div>
						<div class="form-group mt-3 mb-2">
						<select class="form-select1" name="blk_sel_option">
							<option value="0">Svima koji su poslali poruku u intervalu</option>
							<option value="1">Samo registriranima u određenom intervalu</option>
							<option value="2">Svim novim korisnicima (u zadnjih 30 dana)</option>
							<option value="3">Svim neaktivnim</option>
							<option value="4">Svim blokiranim</option>
							<option value="5">Svima koji su pisali danas</option>
						  </select>
						</div>
						  <div class="form-group mt-1 mb-2">
							<label for="comment">Poruka:</label>
							<textarea class="form-control" rows="4" id="blk_message" name="blk_message"></textarea>
						  </div>
						  <div class="form-group mt-1 mb-2">
							<input class="form-check-input" type="checkbox" value="1" id="blk_premium" name="blk_premium">
							<label class="form-check-label" for="blk_premium">Samo pretplatnici</label>
						  </div>
						<button type="button" class="btn btn-primary" id="btn_send_blk">Potvrdi</button>
						<button type="button" class="btn btn-secondary" id="btn_inp_rnd">RND</button>
						<span id="sp_blk_send"></span>
					  </form>
					<!-- end forma crveni box -->
					
					<div style="height: 5vh; margin-top: 20px;" class="float-right">
					<p class="text-right"><a href="analysis.php?ag=<?= $_GET["ag"]; ?>" target="_blank" class="btn btn-info" style="color: white;"><i class="fas fa-solid fa-chart-line"></i> Analiza</a></p>
					</div>
					
				</div>
			</div>
		</div>
		<div class="col-8" style="background: none;max-height: 100vh;">
		    <!-- agenti -->
			<div class="row">
				<div class="d-flex justify-content-center">
				<div class="btn-toolbar mb-3" role="toolbar" aria-label="Toolbar with button groups">
				  <div class="btn-group me-2" role="group" aria-label="First group" id="reloadagents">
					<?php foreach ($cf_agents as $key => $value) { ?>
					<a id="ag<?= $key; ?>" data-ag="<?= $key; ?>" class="btn <?php if (!strcmp($_GET["ag"], $key)) { ?> btn-primary active <?php } else { ?> btn-outline-secondary <?php } ?>" href="index.php?ag=<?= $key; ?>" role="button"><?= $key; ?></a>
					<?php } ?>
				  </div>
				</div>
				</div>
			</div>
			<!-- end of agenti -->
			
			<!--- grupirane poruke po korisniku -->
			<div class="col-md-12" style="max-height: 37vmin; overflow-y: scroll; overflow-x: hidden; padding: 0 20px;">
			<div class="row">
				<table class="table table-hover table-stripped" style="margin: 0 10px 0 10px;">
				  <thead>
					<tr>
					  <th scope="col" style="width: 9%;">Broj</th>
					  <th scope="col">Poruka</th>
					  <th scope="col" style="width: 10%">Datum</th>
					  <th scope="col" style="width: 10%">Status</th>
					</tr>
				  </thead>
				  <tbody id="tbody_groupedMessages">
					<?php foreach ($results as $key => $value) { ?>
					<?php 
						$tr_id = "gc_".$value["mess_client_id"];					
						$th_id = "th_".$value["mess_client_id"];
						$td_id_mess = "td_id_mess_".$value["mess_client_id"];
						$td_id_date = "td_id_date_".$value["mess_client_id"];
					?>
					
						<tr id="<?= $tr_id; ?>" class="<?= tr_status($value["status"]); ?>" data-id="<?= $value["mess_client_id"]; ?>" data-date="<?= strtotime($value["mess_date"]); ?>">
					<th id="<?= $th_id; ?>" scope="row" class="<?php echo ($value["mess_whosent"] == "0") ? "red" : ""; ?>"><?= $value["client_number"]; ?></th>
							<td id="<?= $td_id_mess; ?>" data-bs-toggle="tooltip" data-bs-placement="bottom" title="<?= $value["mess_message"]; ?>"><?= mb_substr($value["mess_message"], 0, $cf_howlongstring_gc); ?></td>
							<td id="<?= $td_id_date; ?>"><?= date('d.m.Y. H:i:s', strtotime($value["mess_date"])); ?></td>
							<td>
								<select id="client_ST<?= $value["mess_client_id"]; ?>" class="form-select sel_status_css" name="client_ST<?= $value["mess_client_id"]; ?>" data-id="<?= $value["mess_client_id"]; ?>">
								  <?php foreach ($cf_status as $key_cfs => $value_cfs) { ?>
								  <option value="<?= $key_cfs; ?>" <?php if (!strcmp($key_cfs, $value["status"])) { echo "selected"; } ?>><?= $value_cfs; ?></option>
								  <?php } ?>
								</select>
							</td>
						</tr>
						<!--<i class="fas fa-exclamation"></i>-->
						
					<?php } ?>
				  </tbody>
				</table>
				<div class="mt-1 mb-1 text-center">
					<button class="btn btn-primary" style="width: 20%;margin: 0 auto;" type="button" id="btn_grouped_showmore" data-from="">Učitaj još (<span id="current_grouped"></span>/<span id="total_grouped"></span>)</button>
				</div>
			</div>
			</div>
			<!-- end of grupirane poruke po korisniku -->
			
			<hr />
			
			<!-- glavni chat -->
			<div class="col-md-12" style="position: relative;" >
				<div class="row">
						<div class="chat d-flex flex-column justify-content-between" style="height: 58vh;">
						
							<div class="chat-history" style="max-height: 45vmin; overflow: scroll;">
							
								<div class="mt-1 mb-1 text-center" id="div_main_chat_show_more" style="display: none;">
									<button class="btn btn-secondary" style="width: 20%;margin: 0 auto;" type="button" id="btn_main_chat_showmore" data-from="" data-clientid="">Učitaj još (<span id="current_main_chat_grouped"></span>/<span id="total_main_chat_grouped"></span>)</button>
								</div>
								
								<ul class="m-b-0" id="ul-mainChat">
									
								</ul>
							</div>
							
							<div class="chat-message clearfix" style="position: absolute;bottom: 0;width: 100%; display: none;" id="div_reply">
								<form name="frm_reply" id="frm_reply">
								<div class="input-group mb-0" style="width: 83%; float: left;">
									<div class="input-group-prepend">
										
									</div>
									<textarea class="form-control" name="txta_reply" placeholder="Unesi poruku ovdje" rows="3" cols="50" id="txta_reply"></textarea>
									
									<input name="inp_reply_clientID" id="inp_reply_clientID" value="" type="hidden" />
									
								</div>
								</form>
								
								<form name="frm_rnd" id="frm_rnd">
									<select name="sel_rnd_quantity" style="width:7%; margin-left: 10px; padding: 5px 0;">
										<?php foreach ($cf_rnd_select as $val_rnd_sel) { ?>
										<option value="<?php echo $val_rnd_sel; ?>"><?php echo $val_rnd_sel; ?></option>
										<?php } ?>
									</select>
									<input name="inp_rnd_clientID" id="inp_rnd_clientID" value="" type="hidden" />
									<button class="btn btn-primary float-right" style="width:7%;" type="button" id="btn_rnd">RND</button>
								</form>
							</div>
						</div>
					
				</div>
			</div>
			<!-- end of glavni chat -->
		</div>
		<div class="col-2" style="height: 100vh; overflow: scroll;">
			<div class="row" style="margin-top: 20px;">
				<div class="card-header">Napomene</div>
						<div class="card-body">
							<div class="col-sm-12">
								
								<form id="frm_client_details">
								  <div class="form-group">
									<label for="Broj">Broj</label>
									<input type="text" class="form-control" name="client_number" id="client_number" placeholder="Unesite broj" disabled="true" value="">
								  </div>
								  <div class="form-group">
									<label for="ime">Ime</label>
									<input type="text" class="form-control" name="client_name" id="client_name" placeholder="Unesite ime" value="">
								  </div>
								  <div class="form-group">
									<label for="date">Datum</label>
									<input type="text" class="form-control" name="client_date" id="client_date" placeholder="Unesite datum" value="">
								  </div>
								  <div class="form-group">
								    <label for="client_agent">Agent</label>
								    <select name="client_ag" class="form-control" id="client_ag">
								        <?php foreach ($cf_agents as $key => $value) { ?>
								        <option value="<?= $key ?>"><?= $key ?></option>
                    					<?php } ?>
								    </select>
								    
								  </div>
								  <div class="form-group">
									<label for="exampleFormControlTextarea1">Napomena</label>
									<textarea class="form-control" name="client_description" id="client_description" rows="7"></textarea>
								  </div>
								  <div class="form-group">
									<input class="form-check-input" type="checkbox" value="1" id="premium" name="premium">
									<label class="form-check-label" for="premium">Pretplatnik</label>
								  </div>
								  <div class="form-check">
									<label class="form-check-label" for="exampleCheck1">Zadnja izmjena: <span id="client_last_edited"></span></label>
								  </div>
								  <input type="hidden" name="client_id" id="client_id" value="" />
								  <button type="submit" onclick="updateClientDetails();" class="btn btn-primary float-right">Spremi</button>
								</form>
								
							</div>
							<br />
							<hr style="margin-top: 20px;" />
							<div class="col-sm-12">
								
								<i class="fas fa-mail-bulk"></i> Bulk: <strong id="sum_blk"></strong>
								&nbsp;
								<i class="fas fa-envelope-open-text"></i> Primljeno: <strong id="sum_tot_received"></strong>
								&nbsp;
								<i class="far fa-clock"></i> 24 sata: <strong id="sum_24h"></strong>
								<br />								
							</div>
						</div>
						
						<!-- start of outbox -->
						<div class="card" style="height: 35vh; overflow: scroll;">
						<div class="card-header">Outbox</div>
						<div class="card-body">
							<table class="table">
							  <thead>
								<tr>
								  <th scope="col">SMS</th>
								  <th scope="col">Broj</th>
								  <th scope="col">Action</th>
								</tr>
							  </thead>
							  <tbody id="outbox_numbers">
								
							  </tbody>
							</table>
						</div>
					</div>
					<!-- end of outbox -->
			</div>
		</div>
	  </div>
	</div>
	<!-- end of container -->
	
	<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js" integrity="sha384-IQsoLXl5PILFhosVNubq5LC7Qb9DXgDA9i+tQ8Zj3iwWAwPtgFTxbJ8NT4GN1R8p" crossorigin="anonymous"></script>
	<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.min.js" integrity="sha384-cVKIPhGWiC2Al4u+LWgxfKTRIcfu0JTxR+EQDz/bgldoEyl4H0zUF0QKbrJ0EcQF" crossorigin="anonymous"></script>
	<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
	<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
	<script src="js/common.js"></script>
	<script src="js/index.js"></script>
	
  </body>
</html>
